/*=========================================================
	
	fiomgr.h
	
	[ύX]
	09/07/16 
	
	t@CI/O}l[WB
	
=========================================================*/
#ifndef FIOMGR_H
#define FIOMGR_H

#include <pspkernel.h>
#include <stdio.h>
#include <stdarg.h>
#include "psp/memory.h"
#include "utils/strutil.h"

/*=========================================================
	}N
=========================================================*/
#define FH_PATH_MAX     255

#define FH_O_RDONLY     PSP_O_RDONLY
#define FH_O_WRONLY     PSP_O_WRONLY
#define FH_O_RDWR       PSP_O_RDWR
#define FH_O_NONBLOCK   PSP_O_NBLOCK
#define FH_O_APPEND     PSP_O_APPEND
#define FH_O_CREAT      PSP_O_CREAT
#define FH_O_TRUNC      PSP_O_TRUNC
#define FH_O_EXCL       PSP_O_EXCL
#define FH_O_NOWAIT     PSP_O_NOWAIT
#define FH_O_LARGEFILE  0x80000000
#define FH_O_ALLOC_HIGH 0x40000000

#define FH_SEEK_SET     PSP_SEEK_SET
#define FH_SEEK_END     PSP_SEEK_END
#define FH_SEEK_CUR     PSP_SEEK_CUR

#ifdef __cplusplus
extern "C" {
#endif

/*=========================================================
	^錾
=========================================================*/
typedef intptr_t FiomgrHandle;

/*=========================================================
	֐
=========================================================*/
/*-----------------------------------------------
	fiomgrOpen
	
	t@CJăt@CIOnh𓾂B
	
	@param: const char *path
		t@CpXB
	
	@param: int flags
		I[vtOB
		PSPSDKŒ`ĂPSP_O_*łÃwb_t@CŒ`ĂFH_O_*łǂł悢B
		32bitȏ̃TCỸt@CJƂ́AFH_O_LARGEFILEw肷B
	
	@param: int perm
		t@C̃p[~bVB
	
	@return: FiomgrHandle
		! 0: Lȃt@CI/Onh
		= 0: G[ (ssȃt@CpX)
-----------------------------------------------*/
FiomgrHandle fiomgrOpen( const char *path, int flags, int perm );

/*-----------------------------------------------
	fiomgrClose
	
	t@CB
	
	@param: FiomgrHandle fh
		Lȃt@CI/OnhB
	
	@return: int
		< 0: G[
-----------------------------------------------*/
int fiomgrClose( FiomgrHandle fh );

/*-----------------------------------------------
	fiomgrRead
	
	t@CwoCgǂݏoB
	I[͕tȂB
	
	@param: FiomgrHandle fh
		Lȃt@CI/OnhB
	
	@param: void *data
		ǂݏof[^̕ۑ|C^B
	
	@param: size_t length
		ǂݏooCgB
	
	@return: int
		ǂݏooCgB
-----------------------------------------------*/
int fiomgrRead( FiomgrHandle fh, void *data, size_t length );

/*-----------------------------------------------
	fiomgrReadln
	
	t@C1sǂݏoB
	WCufgets()̂悤Ȃ́B
	AI[̉s͍폜B
	1sۑobt@̃TCY𒴂Ăꍇ́Ar܂ŃRs[B
	̏ꍇKI['\0'͊܂܂B
	
	ԂlɓǂݏooCgԂAꍇɂĂmaxlength𒴂邱ƂB
	́AsR[hCRLF2oCgŕ\ĂꍇŁA
	̃CuCRLF1Ƃď邽߁A
	ۑobt@Ɋi[oCg1oCgǂݏo\B
	ۑobt@𒴂ĕRs[Ă킯ł͂Ȃ̂ŁAɋCɂKv͂ȂB
	
	@param: FiomgrHandle fh
		Lȃt@CI/OnhB
	
	@param: char *str
		ǂݏo̕ۑ|C^B
	
	@param: size_t maxlength
		ۑobt@̃TCYB
	
-----------------------------------------------*/
int fiomgrReadln( FiomgrHandle fh, char *str, size_t maxlength );

SceOff fiomgrTell( FiomgrHandle fh );
SceOff fiomgrSeek( FiomgrHandle fh, SceOff offset, int whence );
int fiomgrWrite( FiomgrHandle fh, void *data, size_t length );
int fiomgrWriteln( FiomgrHandle fh, void *data, size_t length );
int fiomgrWritef( FiomgrHandle fh, char *buf, size_t buflen, const char *format, ... );
int fiomgrWritefln( FiomgrHandle fh, char *buf, size_t buflen, const char *format, ... );

#ifdef __cplusplus
}
#endif

#endif
